package com.adobe.internal.pdftoolkit.core.fontset;

import com.adobe.fontengine.fontmanagement.FontResolutionPriority;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.fontset.impl.PDFFontSetImpl;

/**
 * Provides methods to acquire a PDFFontSet object. 
 * @author mplunket
 *
 */
public class PDFFontSetManager 
{
	/**
	 * Build a default <code>PDFFontSet</code>.  This fontset uses the <code>INTELLIGENT_LAST</code>
	 * resolution priority.
	 * @return a default <code>PDFFontSet</code>
	 * @throws PDFFontException
	 */
	public static final PDFFontSet getPDFFontSetInstance() 
	throws PDFFontException
	{
		return new PDFFontSetImpl();
	}
	
	/**
	 * Build a default <code>PDFFontSet</code>.
	 * @return a default <code>PDFFontSet</code>
	 * @throws PDFFontException
	 */
	public static final PDFFontSet getPDFFontSetInstance(FontResolutionPriority priority) 
	throws PDFFontException
	{
		return new PDFFontSetImpl(priority);
	}
	
	/**
	 * Build a fontset using the given fontset as a template.  This new fontset
	 * will not refer to the original and both may be changed without interferring with the other.
	 * @param original the fontset to use as a template; must be a fontset made using the <code>PDFFontSetManager</code>
	 * @return a clone of the original fontset
	 * @throws PDFFontException
	 */
	public static final PDFFontSet getPDFFontSetInstance(PDFFontSet original) 
	throws PDFFontException
	{
		if (original instanceof PDFFontSetImpl)
		{
			return new PDFFontSetImpl((PDFFontSetImpl) original);
		}
		return null;
	}
}
