/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.configuration;


import com.adobe.xfa.Arg;
import com.adobe.xfa.Obj;
import com.adobe.xfa.ScriptTable;


/**
 * This class contains all the script functionality associated with the
 * ConfigurationElement class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
class ConfigurationElementScript {

	protected static final ScriptTable moScriptTable = new ScriptTable(
		null,
		"configurationElement",
		null,
		null
	);

	public static void getClassName(Obj pThis, Arg oRetVal) {
		oRetVal.setString(pThis.getClassAtom());
	}
	
	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}
}