/*************************************************************************
 *
 *	File: DataMatrixMatrix.java
 *
 **************************************************************************
 * 
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.xfa.pmp.datamatrixpmp;

/**
 * Ported from DataMatrixMatrix.cpp
 */
class DataMatrixMatrix {

	void create(int cols, int rows) {
		m_matrix = new int[cols * rows];
		m_cols = cols;
		m_rows = rows;
	}

	void set(int col, int row, int value) {
		m_matrix[row * m_rows + col] = value;
	}

	int get(int col, int row) {
		return (m_matrix[row * m_rows + col]);
	}

	int getCols() {
		return (m_cols);
	}

	int getRows() {
		return (m_rows);
	}

	private int m_cols;

	private int m_rows;

	private int[] m_matrix;
}
