/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.service;


import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ResId;


/**
 * A base class for various XFA related services.
 *
 * @exclude from published api.
 */
public class Service {

	/**
	 * Instantiates a service.
	 *
	 * @exclude from published api.
	 */
	public Service() {
	}

	/**
	 * Sets an option.
	 *
	 * @param optionName the name of the option.
	 * @param optionValue the value of the option.
	 * @param bCritical disallow further modification of this option.
	 *
	 * @exclude from published api.
	 */
	public void setOption(String optionName, String optionValue, boolean bCritical) {
		throw new ExFull(ResId.InvalidOptionException);
	}

}
