package com.adobe.xfa.text;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/**
 * @exclude from published api.
 */

class AFEAttrMap {
	private final TextContext mContext;
	private final Map<Object, Integer> mAFEIndexMap = new HashMap<Object, Integer>();
	private final SortedMap<AFEFixedAttr, AFEFixedAttr> mFixedAttrs = new TreeMap<AFEFixedAttr, AFEFixedAttr>();
	private final SortedMap<AFEVarAttr, AFEVarAttr> mVarAttrs = new TreeMap<AFEVarAttr, AFEVarAttr>();
	private AFEFixedAttr mFixedTest;
	private final AFEVarAttrTest mVarTest;
	private Object[] mAFEKeys;
	private final AFEVarAttr mEmptyVarAttr;

	AFEAttrMap (TextContext context) {
		mContext = context;
		mVarTest = new AFEVarAttrTest (this);
		mEmptyVarAttr = new AFEVarAttr (this);
	}

	TextContext getContext () {
		return mContext;
	}

	int getAFEIndexCount () {
		return mAFEIndexMap.size();
	}

	Object[] getAFEKeys () {
		if (mAFEKeys == null) {
			mAFEKeys = new Object [mAFEIndexMap.size()];
			for (Map.Entry<Object, Integer> entry : mAFEIndexMap.entrySet()) {
				mAFEKeys[entry.getValue().intValue()] = entry.getKey();
			}
		}
		return mAFEKeys;
	}

	AFEVarAttr getEmptyVarAttr () {
		return mEmptyVarAttr;
	}

	int mapAFEIndex (Object attribute) {
		Integer i = mAFEIndexMap.get (attribute);
		int result;
		if (i == null) {
			result = mAFEIndexMap.size();
			mAFEIndexMap.put (attribute, Integer.valueOf(result));
			mAFEKeys = null;
		} else {
			result = i.intValue();
		}
		return result;
	}

	AFEFixedAttr mapFixedAttr (DispRun dispRun, int bidiLevel) {
		if (mFixedTest == null) {
			mFixedTest = new AFEFixedAttr (this);
		}
		
		mFixedTest.populate (dispRun, bidiLevel);
		
		AFEFixedAttr result = mFixedAttrs.get (mFixedTest);
		if (result != null)
			return result;
			
		result = mFixedTest;
		mFixedTest = null;
		mFixedAttrs.put (result, result);
		return result;
	}

	AFEVarAttr mapVarAttr (AFEVarAttr base, Object key, Object value) {
		mVarTest.setup (base, key, value);
		
		AFEVarAttr result = mVarAttrs.get (mVarTest);		
		if (result != null)
			return result;
		
		result = mVarTest.create();
		mVarAttrs.put (result, result);
		return result;
	}

	public String toString () {
		StringBuilder result = new StringBuilder ("Pooled attributes:\n\tFixed:");
		for (AFEFixedAttr attr : mFixedAttrs.values()) {
			result.append ("\n\t\t");
			result.append (attr.toString());
		}
		
		result.append ("\n\tVariable:");
		for (AFEVarAttr attr : mVarAttrs.values()) {
			result.append ("\n\t\t");
			result.append (attr.toString());
		}
		
		return result.toString();
	}
}