package com.adobe.xfa.text;

import com.adobe.xfa.gfx.GFXGlyphOrientation;

/**
 * @exclude from published api.
 */

class DispRun extends DispMapItem {
	private TextFrame mpoFrame;
	private TextDisplay mpoDisplay;
	private TextAttr mpoAttr;
//	private TextFontMapID moFontID;
//	private TextFontMapID moComplementaryFontID;
	private int mnLanguageID;
	private int meGlyphOrientation = GFXGlyphOrientation.HORIZONTAL;
	private boolean mbIsComb;
	private boolean mbAllowLigatures;
	private boolean mbAllowKerning;
	private boolean mbUsingUnicodeFont;

	DispRun () {
	}

	DispRun (DispRun oSource) {
		super (oSource);
		copy (oSource, oSource.mpoAttr);
	}

	DispRun (DispRun oSource, int index, int length) {
		super (index, length);
		copy (oSource, oSource.mpoAttr);
	}

	DispRun (DispRun oSource, TextAttr poNewAttr) {
		super (oSource);
		copy (oSource, poNewAttr, true);
	}

	DispRun (TextFrame poFrame, TextAttr poAttr) {
		mpoFrame = poFrame;
		mpoDisplay = poFrame.display();
		setAttr (poAttr);
	}

	DispRun (DispRun oSource, int eNewGlyphOrientation) {
		super (oSource);
		copy (oSource, oSource.mpoAttr);
		meGlyphOrientation = eNewGlyphOrientation;
	}

	TextAttr getAttr () {
		return mpoAttr;
	}

	void setAttr (TextAttr poAttr) {
		if (poAttr == mpoAttr) {
			return;
		}

//		moFontID.setNull();
//		moComplementaryFontID.setNull();

		if (poAttr == null) {
			mpoAttr = null;
		} else {
			TextAttr poFlatAttr = poAttr.conditionalFlatten();
			if (poFlatAttr != null) {
				mpoAttr = poFlatAttr;
			} else {
				mpoAttr = poAttr;
			}
//			if (mpoDisplay != null) {
//				TextFontMap oFontMap = mpoDisplay.getFontMap();
//
//				if (! mpoAttr.fontInstance().isNull()) {
//					FontItem poItem = mpoAttr.fontInstance().getFontItem();
//					if (poItem != null) {
//						if (mbUsingUnicodeFont) {
//							FontItem poUnicodeFont = poItem.getUnicodeFont();
//							if (poUnicodeFont != null) {
//								poItem = poUnicodeFont;
//							}
//						}
//						moFontID = oFontMap.mapJFFont (poItem);
//					}
//				}
//			}
		}
	}

	TextFrame getFrame () {
		return mpoFrame;
	}

	TextDisplay getDisplay () {
		return mpoDisplay;
	}

//	TextFontMapID fontID () {
//		return moFontID;
//	}

//	TextDispWrapper font () {
//		return mpoDisplay.getFontMap().lookup (moFontID);
//	}

//	TextFontMapID complementaryFontID () {
//		if (moComplementaryFontID.isNull()) {
//			moComplementaryFontID = mpoDisplay.getWRS().getComplementaryFontID (this);
//		}
//
//		return moComplementaryFontID;
//	}

//	TextDispWrapper complementaryFont () {
//		return mpoDisplay.getFontMap().lookup (ComplementaryFontID());
//	}

/*
	void forceUnicodeFont () {
// Watson 1260903: Work-around for printer-based font limitations.  AXTE will try to
// reconstruct Unicode characters from the glyph IDs in the line layout.
// However, if the line is laid out by WinSoft's more advanced algorithm,
// there isn't always a mapping to get back to characters.
// Unfortunately, if the run's font is a printer font (i.e. XDC font), glyph IDs
// by definition are not usable --- printer fonts can only be accessed using character data.
// This routine forces the use of a non-printer font of the same typeface in order to allow glyph usage.
// This font is selected in the Unicode encoding, in order to give the largest selection of available glyphs.
// Eliminate situtions where there's no need to get the Unicode font,
// notably if this run represents an embedded object and not text.
		if ((moFontID.getType() == TextFontMapID.TYPE_OBJECT) || mbUsingUnicodeFont || (mpoDisplay == null)) {
			return;
		}
		TextFontMap oFontMap = mpoDisplay.getFontMap();

// Gind the font wrapper for this run's font.
		TextDispFontWrapper poFontWrapper = oFontMap.lookupFont (moFontID);
		if (poFontWrapper == null) {
			return;
		}

// Font item from font wrapper.
		FontItem poFontItem = poFontWrapper.getFontItem();
		if (poFontItem == null) {
			return;
		}

// And finally, Unicode font from font item.
		FontItem poUnicodeFont = poFontItem.getUnicodeFont();
		if (poUnicodeFont != null) {
			moFontID = oFontMap.mapJFFont (poUnicodeFont);
		} else {
			return;
		}

		mbUsingUnicodeFont = true;
	}
*/

	int getLanguageID () {
		return mnLanguageID;
	}

	void setLanguageID (int nLanguageID) {
		mnLanguageID = nLanguageID;
	}

	boolean isRTL () {
		return mpoFrame.isRTL (mpoAttr);
	}

	boolean isIdeographic () {
		return mpoFrame.isIdeographic (mpoAttr);
	}

	boolean isComb () {
		return mbIsComb;
	}

	void setComb (boolean bIsComb) {
		mbIsComb = bIsComb;
	}

	boolean allowLigatures () {
		return mbAllowLigatures;
	}

	void setAllowLigatures (boolean bAllowLigatures) {
		mbAllowLigatures = bAllowLigatures;
	}

	boolean allowKerning () {
		return mbAllowKerning;
	}

	void setAllowKerning (boolean bAllowKerning) {
		mbAllowKerning = bAllowKerning;
	}

	int glyphOrientation () {
		return meGlyphOrientation;
	}

	void setGlyphOrientation (int eGlyphOrientation) {
		meGlyphOrientation = eGlyphOrientation;
	}

//	void forceFont (TextFontMapID oID) {
//		moFontID = oID;
//	}

	void copyFrom (DispRun oSource) {
		if (this != oSource) {
			super.copyFrom (oSource);
			copy (oSource, oSource.mpoAttr);
		}
	}

	void copy (DispRun oSource, TextAttr poAttr, boolean bForceAttr) {
		mpoFrame = oSource.mpoFrame;
		mpoDisplay = oSource.mpoDisplay;

		meGlyphOrientation = oSource.meGlyphOrientation;

		mbIsComb = oSource.mbIsComb;
		mbAllowLigatures = oSource.mbAllowLigatures;
		mbAllowKerning = oSource.mbAllowKerning;
		mbUsingUnicodeFont = oSource.mbUsingUnicodeFont;

		setAttr (poAttr);
//		if (! bForceAttr) {
//			moFontID = oSource.moFontID; // after SetAttr() sets it
//		}
	}

	void copy (DispRun oSource, TextAttr poAttr) {
		copy (oSource, poAttr, false);
	}

	DispRun r () {
		return this;
	}

	void add (DispLine line, int start, int length) {
		line.add (this, start, length);
	}

	DispMapItem cloneMapItem () {
		return new DispRun (this);
	}

	DispMapItem cloneMapItem (int index, int length) {
		return new DispRun (this, index, length);
	}

	void copyFrom (DispMapItem source) {
		assert (source instanceof DispRun);
		copyFrom ((DispRun) source);
	}
}
