/*
 * DO NOT EDIT THE java VERSION OF THE FILE -- EDIT THE txt VERSION INSTEAD!
 *
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.ut;


/**
 * A class to report the com.adobe.xfa package's specification
 * and implementation versions.
 */
public class Version {

	private static boolean mbTestMode = false;

	private static final String Specification = "3.5.0.2034";

	private static final String Implementation = "3.5.0.2034";

	private Version() {
	}

	/**
	 * Gets this package's XFA specification version.
	 * @return the specification version.
	 */
	public static final String getSpecification() {
		if (mbTestMode)
			return "x.x.x.x";
		return Specification;
	}

	/**
	 * Gets this package's XFA implementation version.
	 * @return the implementation version.
	 */
	public static final String getImplementation() {
		if (mbTestMode)
			return "x.x.x.x";
		return Implementation;
	}

	/**
	 * Sets test mode behaviour on or off.  XFA test suites who don't
	 * like having to deal with ever changing version numbers, would
	 * set the test mode, causing the getter methods to return canned
	 * values.
	 *
	 * @exclude from published api -- Mike P Tardif, May 2006.
	 */
	public static final void setTestMode(boolean bMode) {
		mbTestMode = bMode;
	}

}
