// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2012 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================

package com.adobe.xmp.core.parser;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;


/**
 * A StringReader that checks whether the String "<!DOCTYPE" is contained in the stream,
 * with minor performance impact. It does not changes the stream.
 *
 * @author Stefan Makswit
 */
class CheckDocTypeReader extends FilterReader
{
	/** */
	private static final String DOCTYPE = "<!DOCTYPE";
	/** number of matches */
	private int matchPos = 0;


	/**
	 * @see FilterReader#FilterReader(Reader)
	 */
	public CheckDocTypeReader(Reader in)
	{
		super(in);
	}


	/**
	 * @see StringReader#read(char[], int, int)
	 */
	public int read(char[] cbuf, int off, int len) throws IOException
	{
		int result = super.read(cbuf, off, len);

		for (int i = off; i < off + result; i++)
		{
			char c = cbuf[i];

			if (c == DOCTYPE.charAt(matchPos))
			{
				matchPos++;
				if (matchPos >= 9)
				{
					// <!DOCTYPE contained in document
					throw new IOException("DOCTYPE is disallowed");
				}
			}
			else
			{
				matchPos = 0;
				if (c == DOCTYPE.charAt(matchPos))
				{
					matchPos = 1;
				}
			}
		}

		return result;
	}
}
