/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2021 Adobe
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

package com.day.cq.analytics.sitecatalyst.util;

import org.apache.http.client.methods.HttpRequestBase;
import org.osgi.annotation.versioning.ProviderType;

/**
 * The {@code WebService} represents an interface to interact with the Adobe Target API.
 * <p>
 * Methods exposed in this interface are only the methods required for the integration.
 * For more details about the complete API please visit the API documentation at
 * <a href="http://developers.adobetarget.com/api/">Adobe Target API</a>.
 * </p>
 */
@ProviderType
public interface WebService {

    public String request(HttpRequestBase request, AnalyticsConfig targetConfig) throws Exception;

}