/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2019 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package com.day.cq.analytics.testandtarget.workspaces;

import java.util.Set;

import javax.annotation.Nonnull;

import com.day.cq.wcm.webservicesupport.Configuration;

/**
 * The <code>WorkspacesProvider</code> represents an interface to get the configured/available Adobe Target Workspaces.
 */
public interface WorkspacesProvider {

    /**
     * @param config Ims Target configuration
     * @throws WorkspacesProviderException if a problem occurs while fetching the workspaces.
     * @throws WorkspacesConfigurationException if the Ims Target Configuration is invalid
     * @throws IllegalArgumentException  if the passed configuration is null
     * @return a set of {@link Workspace}s containing the configured/available Adobe Target Workspaces
     */
    Set<Workspace> getWorkspaces(@Nonnull Configuration config);
}
