/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.connector;

import java.util.Calendar;

import org.apache.sling.api.resource.Resource;

/**
 * <code>ConnectorResource</code> provides unified access to content exposed
 * by various JCR connector implementations.
 */
public interface ConnectorResource extends Resource {

    /**
     * Executes a fulltext query on this resource. The scope of the query is
     * limitted to the descendants of this resource.
     *
     * @param fulltext the fulltext query statement.
     * @return an iterator over result set.
     */
    public Iterable<ConnectorResource> executeQuery(String fulltext);

    /**
     * Lists the children of this resource.
     *
     * @return the children of this resource.
     */
    public Iterable<ConnectorResource> getChildren();

    /**
     * @return <code>true</code> if this resource is a container that contains
     * other resources; <code>false</code> otherwise.
     */
    public boolean isContainer();

    /**
     * @return the date when this resource was last modified.
     */
    public Calendar getLastModified();

    /**
     * @return the mime type of this resource.
     */
    public String getMimeType();
}
