/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.mcm.api;

import java.util.Collection;
import java.util.Iterator;

import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

/**
 * Plugin to extend MCM with {@link Experience}s and {@link Touchpoint}s.
 * Being registered in the {@link AdapterFactory} of the MCM package during bundle
 * installation.
 */
public interface MCMPlugin {

	/**
	 * An id string for identification of the plugin - for example for the Javascript
	 * plugin part. Should refer to only one plugin.
	 * @return for example <code>twitter</code>
	 */
	String getPluginId();
	
	Collection<String> getTouchpointRootComponents();
	
	Collection<String> getExperienceRootComponents();

	/**
	 * Should try it's best to make an experience out of the adaptable. Should
	 * not check for the component type, because component types might be subtyped
	 * and AdapterFactory can be configured to deal with that by setting up indirection
	 * via setting up a configuration:
	 * <code>com.day.cq.mcm.impl.MCMConfiguration-exampleconfig</code>
	 * with a property setting of:
	 * <pre>
	 * 
	 * </pre>
	 * 
	 * @param adaptable
	 * @return
	 */
	Experience makeExperience(Resource adaptable);

	/**
	 * Should try it's best to make an experience out of the adaptable. Should
	 * not check for the component type, because component types might be subtyped
	 * and AdapterFactory can be configured to deal with that by setting up indirection
	 * via configuration of a 
	 * @param adaptable
	 * @return
	 */
	Touchpoint makeTouchpoint(Resource adaptable);

	/**
	 * Finds the touchpoints referenced underneath the given path and/or the touchpoints
	 * that might display experience of the given campaign if the path is a campaign.
	 * @param pathOrCampaignPath
	 * @return
	 */
	Iterator<Resource> findReferencedTouchpoints(ResourceResolver rr, String pathOrCampaignPath);
}
