/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2011 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

package com.day.cq.replication;

import java.io.File;
import java.io.IOException;

/**
 * Implements a factory that creates replication content.
 */
public interface ReplicationContentFactory {

    /**
     * Creates binary replication content for the given file. note we cannot use
     * the last modified of the file, since it's low precision.
     *
     * @param mimeType the mime type of the content
     * @param file the file containing the data
     * @param isTemp if <code>true</code> file is temporary file and will be
     *        removed after this call.
     * @return the replication content
     * @throws IOException if an error occurs
     */
    ReplicationContent create(String mimeType, File file, boolean isTemp)
            throws IOException;

    /**
     * Creates binary replication content for the given file. note we cannot use
     * the last modified of the file, since it's low precision.
     *
     * @param mimeType the mime type of the content
     * @param file the file containing the data
     * @param lastModified the last modified time in ms.
     * @param isTemp if <code>true</code> file is temporary file and will be
     *        removed after this call.
     * @return the replication content
     * @throws IOException if an error occurs
     */
    ReplicationContent create(String mimeType, File file, long lastModified, boolean isTemp)
            throws IOException;

    /**
     * Creates the replication content based on a facade.
     * @param facade the facade
     * @return the replication content
     */
    ReplicationContent create(ReplicationContentFacade facade);

    /**
     * Closes this factory and releases all allocated resources.
     * @since 5.4
     */
    void close();

}