/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2011 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.cq.replication;

/**
 * The <code>TransportContext</code> is used as context when replicating
 * content. Usually a context is created for each agent / transport handler pair.
 * The handler can use the context to store config dependant states and can assume
 * a new context for changed configuration.
 */
public interface TransportContext {

    String getName();
    
    AgentConfig getConfig();

    Discardable getAttribute(String name);

    Discardable setAttribute(String name, Discardable attr);

    interface Discardable {

        void discard();
    }
}