/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.reporting;

import java.util.Locale;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;

import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

/**
 * Interface that defines a cell value.
 */
public interface CellValue extends Comparable<CellValue> {

    /**
     * Gets a JCR compatible {@link Value} object for the represented cell value.
     *
     * @param session The repository session to create the value for
     * @return The JCR {@link Value} object
     * @throws RepositoryException if no suitable {@link Value} object could be created
     */
    Value getJCRValue(Session session) throws RepositoryException;

    /**
     * <p>Adds the value to the specified {@link JSONWriter}.</p>
     *
     * <p>The caller must ensure that the cell value can be directly written using the
     * corresponding {@link JSONWriter#value} method. If the value is actually represented
     * as a JS object, {@link JSONWriter#object()} resp. {@link JSONWriter#array()} must
     * be able to be called.</p>
     *
     * <p>The specified {@link Locale} might be used for use formatting the value in a
     * locale-specific way, for example for formatting dates and times.</p>
     *
     * @param writer The JSON writer
     * @param locale The request's {@link Locale}
     * @throws JSONException if writing the JSON representation failed
     */
    void toJSON(JSONWriter writer, Locale locale) throws JSONException;

    /**
     * Returns a "guaranteed" string representation of the value. This is used for creating
     * lists, etc.
     *
     * @return The "guaranteed" string representation of the value
     */
    String getString();

}
