/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.reporting;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

/**
 * This interface must be implemented by classes that are used for resolving cell values.
 */
public interface ValueResolver {

    /**
     * Configures the value resolver from the specified data node.
     *
     * @param configNode The node the value resolver is configured from; may be
     *                   <code>null</code> if no explicit configuration is available
     *                   (resolver should initialize itself with default values in that
     *                   case)
     * @throws RepositoryException if configuring the resolver has failed
     */
    void configure(Node configNode) throws RepositoryException;

    /**
     * Resolves the specified value.
     *
     * @param session The session to be used for resolving the value (managed by caller)
     * @param value The value to resolve
     * @param context The context the report is configured to be used from
     * @return The resolved value
     * @throws RepositoryException if the value could not be resolved due to a repository
     *                             problem
     */
    CellValue resolve(Session session, CellValue value, Context context)
            throws RepositoryException;

}
