/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.rewriter.linkchecker;

import org.apache.sling.api.SlingHttpServletRequest;

/**
 * The <code>LinkChecker</code> interface defines method needed for link checking
 * of internal and external urls.
 */
public interface LinkChecker {

    /**
     * This method checks if the passed url is a valid internal or external link.
     * It might happen that a invalid external link is marked valid since the external
     * link validation is implementation dependant and will for sure happen asynchronously
     * (because of performance reasons)
     *
     * @param url url to validate
     * @param settings linkchecker settings. see {@link LinkCheckerSettings}
     * @return the validity information for this url
     *
     * @deprecated since 5.3 - use {@link #getLink} instead.
     */
    @Deprecated
    LinkValidity getLinkValidity(String url, LinkCheckerSettings settings);

    /**
     * This method checks if the passed url is a valid internal or external link.
     * It might happen that a invalid external link is marked valid since the external
     * link validation is implementation dependant and will for sure happen asynchronously
     * (because of performance reasons).
     *
     * @param href url to validate
     * @param settings linkchecker settings. see {@link LinkCheckerSettings}
     * @return the link information for this url
     *
     * @since 5.3
     */
    Link getLink(String href, LinkCheckerSettings settings);

    /**
     * Returns the settings that are used for the given request. If the
     * request does not contain them, new settings are created and set
     * to the request.
     *
     * @param request the sling request
     * @return linkchecker settings
     */
    LinkCheckerSettings createSettings(SlingHttpServletRequest request);

    /**
     * Checks if the given url is a special link, i.e. starts with one of the
     * configured prefixes.
     *
     * @param url url to check
     * @return <code>true</code> if special
     */
    boolean isSpecial(String url);

}
