/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.designimporter.api;

import com.day.cq.wcm.designimporter.parser.HTMLContentType;

/**
 * Interface for classes that provide html compatible content like markup, scritps, links etc.
 */
public interface HTMLContentProvider {

    /**
     * Gets the content of the type {@link HTMLContentType}
     * 
     * @param htmlContentType
     * @return
     */
    Object getContent(HTMLContentType htmlContentType);

    /**
     * Indicates whether the passed {@link HTMLContentType} is supported or not
     * 
     * @param htmlContentType
     * @return
     */
    boolean supportsContent(HTMLContentType htmlContentType);
}
