package com.day.cq.wcm.designimporter.parser.taghandlers.factory;

import com.day.cq.wcm.designimporter.api.TagHandler;
import com.day.cq.wcm.designimporter.api.TagHandlerFactory;
import com.day.cq.wcm.designimporter.parser.taghandlers.NonScriptTagHandler;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.osgi.framework.Constants;

/**
 * The TagHandlerFactory that rolls out {@link NonScriptTagHandler} instances
 */
@Service
@Component(metatype = true)
@Properties({
        @Property(name = Constants.SERVICE_RANKING, intValue = 5001, propertyPrivate = false),
        @Property(name = TagHandlerFactory.PN_TAGPATTERN, value = NonScriptTagHandlerFactory.TAG_PATTERN)
})
public class NonScriptTagHandlerFactory implements TagHandlerFactory {

    static public final String TAG_PATTERN = "<script(.*?)type=\"(?!(text|application)/javascript)(.*?)>";

    public TagHandler create() {
        return new NonScriptTagHandler();
    }
}
