/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.emulator;

/**
 * The <code>Emulator</code> interface specifies emulators.
 *
 * @since CQ 5.4.0
 */
public interface Emulator {

    final static String RESOURCE_TYPE = "wcm/emulator/components/base";

    String PN_CANROTATE = "canRotate";
    String PN_TOUCHSCROLLING = "touchScrolling";
    String PN_WIDTH = "width";
    String PN_HEIGHT = "height";
    String PN_PIXELRATIO = "device-pixel-ratio";

    /**
     * Node names
     */
    String NN_EMULATORCONFIG = "cq:emulatorConfig";

    /**
     * Returns the path of the CSS to be used for displaying the page content in the emulator. This is set via {@link
     * #setContentCssPath(String)}.
     *
     * @return A <code>String</code> representing the content CSS path, or <code>null</code> if never set.
     */
    String getContentCssPath();

    /**
     * Instructs the emulator to use the given <code>cssPath</code> for displaying the page content. This is the same
     * CSS path as used for rendering the page e.g. on a publish instance.
     *
     * @param cssPath ><code>String</code> representing the css path.
     */
    void setContentCssPath(String cssPath);

    /**
     * Returns the description of this emulator.
     *
     * @return A <code>String</code> representing the description, or <code>null</code> if not defined.
     */
    String getDescription();

    /**
     * Returns the name of this emulator.
     *
     * @return A <code>String</code> representing the name.
     */
    String getName();

    /**
     * Returns the path of this emulator.
     *
     * @return A <code>String</code> representing the path.
     */
    String getPath();

    /**
     * Returns the title of this emulator.
     *
     * @return A <code>String</code> representing the title or <code>null</code> if not defined.
     */
    String getTitle();

    /**
     * Indicates whether the device represented by this emulator supports device rotation (dual mode).
     *
     * @return <code>true</code> if rotation is supported.
     */
    boolean canRotate();

    /**
     * Indicates whether the devices represented by this emulator uses touch scrolling.
     *
     * @return <code>true</code> if touch scrolling is supported.
     */
    boolean hasTouchScrolling();

    /**
     * Returns the width of this emulator.
     *
     * @return An <code>int</code> representing the width or <code>-1</code> if not defined.
     */
    int getWidth();

    /**
     * Returns the height of this emulator.
     *
     * @return An <code>int</code> representing the height or <code>-1</code> if not defined.
     */
    int getHeight();

    /**
     * Returns the pixel ratio of this emulator.
     *
     * @return A <code>double</code> representing the pixel ratio or <code>1</code> if not defined.
     */
    double getPixelRatio();

}
