/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.job;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;

import org.apache.sling.event.EventUtil;
import org.osgi.service.event.Event;

import com.day.cq.workflow.exec.WorkItem;

/**
 * The <code>WorkflowJob</code> class provides a utility for creating event
 * triggered job used for programmed/scripted workflow steps.
 */
public class WorkflowJob implements Serializable {
	/** Generated serial version UID. */
	private static final long serialVersionUID = 5670996916430565635L;

	/** The job topic for adding an entry to the audit log. */
	public static final String JOB_TOPIC = "com/day/cq/workflow/job";

    public static final String JOB_TOPIC_WC = "com/day/cq/workflow/job/*";

    /** The event property holding the {@link WorkflowJob}. */
	public static final String WORKFLOW_JOB = "com.day.cq.workflow.job";

    public static final String WORKFLOW_JOB_ID = "com.day.cq.workflow.jobid";

    /** The serialized {@link WorkItem} {@link Map} of the job. */
	protected Map item;

    /** Creates a new WorkflowJob.
	 *
	 * @param item creates the  {@link WorkflowJob} instance using {@link Map}
	 *
	 * */
	public WorkflowJob(Map item) {
		if (item == null) {
			throw new IllegalArgumentException("Resource must not be null.");
		}
		this.item = item;
	}

	/** Returns the {@link WorkItem} {@link Map}of the job
	 *
	 * @return Map {@link Map} returns the workflow item map
	 * */
	public Map getWorkItemMap() {
		return item;
	}

	/** Convenience method to create a job event for the workflow job.
	 *
	 * @param retryCount integer.  number of retries
	 *
	 * @param numOfParallelProcs not currently used
	 *
	 * @param jobId the job id to use
	 *
	 * @return Event {@link Event} the job event created
	 * */
	public Event createJobEvent(Integer retryCount, int numOfParallelProcs,
                                String jobId) {
		final Dictionary<String, Object> props = new Hashtable<String, Object>();
		props.put(WORKFLOW_JOB, this);
		props.put(EventUtil.PROPERTY_JOB_RETRIES, retryCount);
        if (item.get("workflowModelId") != null) {
        	String workflowModelId = (String)item.get("workflowModelId");
            props.put(EventUtil.PROPERTY_JOB_TOPIC, JOB_TOPIC + workflowModelId);
        } else {
            props.put(EventUtil.PROPERTY_JOB_TOPIC, JOB_TOPIC);
        }

        props.put(WORKFLOW_JOB_ID, jobId);

        return new Event(EventUtil.TOPIC_JOB, props);
	}
}
