/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 1997 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.crx.statistics;

import javax.jcr.Session;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Item;
import java.util.Iterator;

/**
 * <code>Report</code> is the abstract base class for all reports.
 *
 * @author mreutegg
 */
public abstract class Report {

    /**
     * The path where the query statistics are stored.
     */
    private final String dataPath;

    /**
     * Report constructor.
     *
     * @param dataPath the path where the query statistics are stored.
     */
    public Report(String dataPath) {
        this.dataPath = dataPath;
    }

    /**
     * @return the path where the query statistics are stored.
     */
    protected String getDataPath() {
        return dataPath;
    }

    /**
     * Returns the node where the query statistics are stored or
     * <code>null</code> if it doesn't exist.
     *
     * @param session the sessio, which gives access to the workspace.
     * @return the node where the query statistics are stored.
     * @throws RepositoryException if an error occurs while reading from the
     *                             repository.
     */
    protected Node getDataNode(Session session) throws RepositoryException {
        if (session.itemExists(dataPath)) {
            Item item = session.getItem(dataPath);
            if (item.isNode()) {
                return (Node) item;
            }
        }
        return null;
    }

    /**
     * Runs the report and returns a result iterator over <code>Object[]</code>
     * instances.
     *
     * @param session the session giving access to the workspace.
     * @return Iterator over {@link Object[]} results.
     * @throws RepositoryException if an error occurs while reading from the
     *                             repository.
     */
    public abstract Iterator getResult(Session session) throws RepositoryException;
}
