/*************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2020 Adobe
 *  All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.util;

/**
 * A <code>HandleExpander</code> is used to expand a globbing pattern to a list
 * of handles, that match the given pattern. This 'expansiion' is done
 * unix-shell-like. for example the pattern <pre>/site/*</pre> could be expanded
 * to <pre>/site/en, /site/fr</pre>.
 *
 * @version $Revision: 1.9 $, $Date: 2004-08-22 06:56:09 +0200 (Sun, 22 Aug 2004) $
 * @author tripod
 * @since antbear
 * Audience dev
 */
public interface HandleExpander {

    /**
     * Expand the handles to the given pattern.
     * @param pattern the pattern to match.
     * @return an array of handles that are expanded from the pattern
     */
    public String[] expand(String pattern);
}
