/*
 * File: TTOutline.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2006 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is
 *      obtained from Adobe Systems Incorporated.
 *
 */

package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.OutlineConsumer2;
import com.adobe.fontengine.font.UnsupportedFontException;

/** A TrueType outline.
 */

public abstract class TTOutline {
  abstract TTPoint getPoint (int index) throws InvalidGlyphException;
  
  abstract int getNumOutlinePoints () throws InvalidGlyphException;
  
  abstract int getNumContours ();
  
  abstract int getContourNextPoint (int contour, int index)  throws InvalidGlyphException;

  abstract int getContourFirstPoint (int contour) throws InvalidGlyphException;
  
  abstract int getContourLastPoint (int contour) throws InvalidGlyphException;
  
  abstract public TTSimpleOutline getMerged ();
  
  public boolean unscaledCoordinatesAreInvalid = false;
  
  abstract public void scale (int unitsPerEm, Matrix em2px);
  abstract public void translate();
     
  abstract public void instruct (TTInterpreter interpreter)
  throws InvalidGlyphException, UnsupportedFontException;
  
  abstract public int getScanType ();

  abstract public void toConsumer (OutlineConsumer c) throws InvalidFontException;
  abstract public void toConsumer2 (OutlineConsumer2 c) throws InvalidFontException;
}
