/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2014 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

package com.adobe.granite.socketio;

import javax.annotation.Nonnull;

import org.apache.sling.commons.json.JSONArray;

import org.osgi.annotation.versioning.ProviderType;

/**
 * Socket.IO listener is used to consume ack responses from {@link SocketIOSocket#emit(String, org.apache.sling.commons.json.JSONArray)}
 * calls.
 */
@ProviderType
public interface SocketIOAckListener {

    /**
     * Allows the listener to specify a time for the callback timeout.
     * @return the timeout or 0 to use the default timeout.
     */
    long getCallbackTimeout();

    /**
     * Called when the ack is received.
     * @param data the data
     */
    void onAck(@Nonnull JSONArray data);

    /**
     * Called when waiting for the ack response timed out.
     */
    void onTimeout();

}