/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.configuration;


import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.ut.BooleanHolder;


/**
 * An element that represents a value capable of containing data.
 *
 * @author Ian Benedict Carreon
 * @author Mike Tardif (ported to Java)
 * @exclude from published api -- Mike Tardif, May 2006.
 */
public class ConfigurationValue extends ConfigurationElement {

    /**
     * Constructor.
     */
	public ConfigurationValue(Element parent, Node prevSibling,
										int classTag, String className) {
		super(parent, prevSibling, null, className, className,
											null, classTag, className);
	}

    /**
     * Constructor.
     */
	public ConfigurationValue(Element parent, Node prevSibling) {
		super(parent, prevSibling, null, XFA.CONFIGURATIONVALUE,
					XFA.CONFIGURATIONVALUE, null,
						XFA.CONFIGURATIONVALUETAG, XFA.CONFIGURATIONVALUE);
	}
	/**
	 * Get the data associated with this configuration value element.
	 *
	 * @return the configuration value.
	 */
	public Attribute getValue() {
		return getValue(null);
	}

	/**
	 * Get the data associated with this configuration value element.
	 *
	 * @param oIsDefault set to true if the value data is the default value.
	 * @return the configuration value.
	 */
	public Attribute getValue(BooleanHolder oIsDefault) {
		TextNode textNode = null;
		if (getXFAChildCount() == 1)
			textNode = (TextNode)getFirstXFAChild();
		int eParentTag = XFA.XFA_START;
		if (getXFAParent() != null)
			eParentTag = getXFAParent().getClassTag();
		if (textNode != null) {
			if (oIsDefault != null)
				oIsDefault.value = false;
			return getModel().getSchema().newAttribute(getClassTag(),
											textNode.getValue(), eParentTag);
		}
		if (oIsDefault != null)
			oIsDefault.value = true;
		return getModel().getSchema().defaultAttribute(getClassTag(),
																eParentTag);
	}

	public ScriptTable getScriptTable() {
		return ConfigurationValueScript.getScriptTable();
	}

	/**
	 * Set the data associated with this configuration value element.
	 *
	 * @param oData a string to set/replace the data associated
	 * with this configuration value element.
	 */
	public void setValue(Attribute oData) {
		if (getXFAChildCount() == 1) {
			// Replace the data value
			TextNode textNode = (TextNode)getFirstXFAChild();
			textNode.setValue(oData.toString(),true,false);
		}
		else {
			getModel().createTextNode(this, null, oData.toString());
		}
// TODO turn off transientFlag
//		makeNonDefaultProperty();
	}

}
