/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2011 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.cq.replication;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The replication content filter chain is passed to content builders
 * to support filtering of content during replication.
 *
 * The chain uses all available filters and queries them one after
 * the other.
 *
 * @since 5.14
 */
@ProviderType
public interface ReplicationContentFilterChain {

    /**
     * Chain accepting all operations
     */
    ReplicationContentFilterChain ALLOW_ALL = new ReplicationContentFilterChain() {

        public boolean allowDescent(Node node) throws RepositoryException {
            return true;
        }

        public boolean accept(Property property) throws RepositoryException {
            return true;
        }

        public boolean accept(Node node) throws RepositoryException {
            return true;
        }
    };

    /**
     * Indicates whether all available {@link com.day.cq.replication.ReplicationContentFilter}s accept the given
     * node for inclusion in the replication content.
     *
     * @param node    The {@link javax.jcr.Node} to check.
     * @return <code>true</code> if the node is accepted by every available filter.
     * @throws RepositoryException thrown in case of failure
     */
    boolean accept(final Node node)
    throws RepositoryException;

    /**
     * Indicates whether all of the available {@link com.day.cq.replication.ReplicationContentFilter}s accept the given
     * property for inclusion in the replication content.
     *
     * @param property The {@link javax.jcr.Property} to check.
     * @return <code>true</code> if the node is accepted by every available filter.
     * @throws RepositoryException thrown in case of failure
     */
    boolean accept(final Property property)
    throws RepositoryException;

    /**
     * Indicates whether all of the available {@link com.day.cq.replication.ReplicationContentFilter}s accept the given
     * node for recursion into its children.
     *
     * @param node    The {@link javax.jcr.Node} to check.
     * @return <code>true</code> if the node is accepted by traversal into its children.
     * @throws RepositoryException thrown in case of failure
     */
    boolean allowDescent(final Node node)
    throws RepositoryException;
}