/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.launches.api;

import org.apache.sling.api.resource.Resource;

public interface LaunchSource {
    /**
     * Returns the root resource the Launch Source belongs to (in the production tree)
     * @return Launch source root resource
     */
    Resource getSourceRootResource();

    /**
     * Returns <code>true</code> if the current <code>LaunchSource</code> has been created with inclusion of sub pages
     * @return <code>true</code> if the launch Source is deep
     */
    boolean isDeep();
}
