/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/


package com.adobe.cq.msm.ui.models.alllivecopies;

import java.util.*;
import java.util.regex.Pattern;

import javax.annotation.PostConstruct;
import javax.jcr.RangeIterator;

import com.adobe.cq.msm.ui.util.StatusDetails;
import com.adobe.cq.msm.ui.util.MSMUtil;
import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.io.JSONStringer;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;

import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.wcm.msm.api.BlueprintManager;
import com.day.cq.wcm.msm.api.LiveRelationshipManager;

@Model(adaptables = SlingHttpServletRequest.class,
        adapters = LiveCopyTable.class,
        resourceType = "wcm/msm/gui/components/alllivecopies")
public class LiveCopiesTable implements LiveCopyTable {

    @Self
    protected SlingHttpServletRequest request;

    private Resource resource;
    protected Resource rootResource;
    private ResourceResolver resourceResolver;


    protected LiveRelationshipManager relationMgr;

    protected BlueprintManager bpm;


    private Map<String, String> tableAttrbsMap;

    private boolean tableExists;


    private Map<String, String> liveCopiesMap;

    protected Pattern excludePattern;

    @ScriptVariable
    protected XSSAPI xssAPI;

    @OSGiService
    private ExpressionResolver expressionResolver;


    private List<Resource> childResources = new LinkedList<Resource>();

    protected String rootPath;



    @PostConstruct
    public void postConstruct() throws Exception {
        this.resource = request.getResource();
        this.resourceResolver = request.getResourceResolver();
        relationMgr = resourceResolver.adaptTo(LiveRelationshipManager.class);
        bpm = resourceResolver.adaptTo(BlueprintManager.class);
        ExpressionHelper exp = new ExpressionHelper(expressionResolver, request);
        rootPath = StringUtils.trimToNull(request.getRequestPathInfo().getSuffix());
        this.rootResource = resourceResolver.getResource(rootPath);

        if (rootResource == null) {
            tableExists = false;
            return;
        }

        Config cfg = new Config(resource);
        String filter = cfg.get("exclude", "");
        excludePattern = Pattern.compile(filter);

        tableExists = true;
        String src = StringUtils.trimToNull(exp.getString(cfg.get("src", String.class)));
        String layoutName = "foundation-layout-table";
        String selectionCount = cfg.get("selectionCount", "multiple");
        tableAttrbsMap = new HashMap<String, String>();
        tableAttrbsMap.put("data-foundation-collection-id", rootPath);
        tableAttrbsMap.put("data-foundation-collection-src", src);
        tableAttrbsMap.put("data-foundation-selections-mode", selectionCount);
        tableAttrbsMap.put("data-foundation-mode-group", cfg.get("modeGroup", String.class));
        tableAttrbsMap.put("data-foundation-layout-table-hasmore", "false");

        String layoutJson = new JSONStringer()
                .object()
                .key("name").value(layoutName)
                .key("sortMode").value(cfg.get("sortMode", String.class))
                .key("layoutId").value(resource.getName()) // This is used as an id to identify the layout when there are multiple layouts to represent the same collection.
                .endObject()
                .toString();

        tableAttrbsMap.put("class", cfg.get("granite:rel", "cq-wcm-msm-all-live-copies") + " foundation-layout-util-maximized-alt foundation-collection foundation-layout-table coral-Table-wrapper coral-Table-wrapper--sticky " + layoutName);

        tableAttrbsMap.put("data-foundation-layout", layoutJson);
        if ("multiple".equals(selectionCount)) {
            tableAttrbsMap.put("multiple", selectionCount);
            tableAttrbsMap.put("selectionMode", cfg.get("selectionMode", "none"));
        }
        tableAttrbsMap.put("selectable", "selectable");

        RangeIterator rootRelations = relationMgr.getLiveRelationships(rootResource, null, null);

        liveCopiesMap = MSMUtil.getFilteredNames(rootRelations);

        Iterator<Resource> resourceIterator = rootResource.listChildren();

        while (resourceIterator.hasNext()) {
            childResources.add(resourceIterator.next());
        }
    }

    public List<LiveCopiesRow> getRows() {
        List<LiveCopiesRow> returnValue = new LinkedList<LiveCopiesRow>();
        try {
            for (Resource resource : getChildResources()) {
                if (!isResourceAcceptable(resource)) {
                    continue;
                }
                if (MSMUtil.isPage(resource) || resource.isResourceType("sling:Folder") || resource.isResourceType("sling:OrderedFolder")) {
                    String relSourcePath = MSMUtil.getRelativeSourcePath(rootResource, resource);
                    String relPath = "";
                    if (resource.getPath().startsWith(rootPath + "/")) {
                        relPath = resource.getPath().substring(rootPath.length() + 1);
                        String rowTitle = MSMUtil.getTitle(resourceResolver, resource);
                        String rowPath = resource.getPath();
                        String thumbnailPath = xssAPI.getValidHref(request.getContextPath() + MSMUtil.getThumbnailUrl(resourceResolver, resource, 48, 48));
                        List<LiveCopiesCell> cellInfo = new ArrayList<LiveCopiesCell>();
                        boolean isBlueprint = false;

                        for (String liveCopyPath : liveCopiesMap.keySet()) {

                            if (!StringUtils.isEmpty(liveCopyPath)) {
                                String currliveCopyPath = String.format("%s/%s", liveCopyPath, relPath);
                                String statusMesg = MSMUtil.getStatus(relationMgr, resource, currliveCopyPath);
                                StatusDetails statusDetails = MSMUtil.STATUS_DETAIL_MAP.get(statusMesg);
                                Map<String, String> cellAttrbs = MSMUtil.getLiveCopyCellAttributes(xssAPI, currliveCopyPath, resource.getPath(), statusMesg);
                                if (!isBlueprint &&
                                        statusMesg != MSMUtil.MSM_STATUS_TARGET_DOES_NOT_EXIST) {

                                    isBlueprint = true;
                                }


                                LiveCopiesCell allLiveCopiesCell = new LiveCopiesCell(statusDetails.getIconName(), statusDetails.getIconClass(), statusDetails.getStatusMessage(), cellAttrbs);
                                cellInfo.add(allLiveCopiesCell);
                            }

                        }

                        // root resource does not have live copies but current row resource might have
                        if (!isBlueprint && liveCopiesMap.isEmpty()) {
                            isBlueprint = MSMUtil.isResourceBlueprint(bpm, relationMgr, resource);
                        }
                        String rowActionRels = MSMUtil.getBlueprintActionRels(isBlueprint);
                        returnValue.add(new LiveCopiesRow(true, rowPath, rowTitle, cellInfo, thumbnailPath, rowActionRels, relSourcePath));

                    }
                }
            }
        }catch(Exception ex){

        }
        return returnValue;
    }


    private boolean isResourceAcceptable(Resource currResource) {
        if (excludePattern.matcher(currResource.getPath()).matches()) {
            return false;
        } else if (MSMUtil.isPage(currResource)) {
            return true;
        } else if (currResource.isResourceType("sling:Folder") || currResource.isResourceType("sling:OrderedFolder")) {
            final String currPath = currResource.getPath();
            if (currPath.startsWith("/content/experience-fragments")) {
                return true;
            } else if (currPath.startsWith("/content/campaigns")) {
                return false;
            }
        }
        return MSMUtil.isFolder(resource);
    }

    private List<Resource> getChildResources(){
        return childResources;
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public Map<String, String> getColumns() {
        return liveCopiesMap;
    }

    public Map<String, String> getTableAttrbs() {
        return tableAttrbsMap;
    }

    public boolean tableExist() {
        return tableExists;
    }

    public boolean hasChildren() {
        if (getRows().isEmpty()) {
            return false;
        }
        return true;
    }

    public int columnsSize() {
        return liveCopiesMap.size() + 2 ;
    }

}
