/*
*
*	File: FontDescription.java
*
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2004-2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
*/
package com.adobe.fontengine.font;

import java.io.Serializable;

/**
 * This class is the base class used for any description of a font.  These descriptions
 * are the way that a font can be represented in certain systems such CSS.
 *
 * <h4>Synchronization</h4>
 * 
 * Concrete sub-classes of this class are immutable after construction and
 * contain no mutable static data. It is therefore threadsafe.
 */
public abstract class FontDescription implements Serializable
{
    /* Serialization signature is explicitly set and should be 
     * incremented on each release to prevent compatibility.
     */
    static final long serialVersionUID = 1;
}
