package com.adobe.xfa.gfx;

/**
 * @exclude from published api.
 */
public class GFXGlyphOrientation {
	public static final int HORIZONTAL = 0;
	public static final int VERTICAL = 1;
	public static final int HORIZONTAL_ROTATED = 2;
	public static final int VERTICAL_UPRIGHT = 3;

	public static boolean usesHorizontalGlyphs (int orientation) {
		return (orientation == HORIZONTAL) || (orientation == HORIZONTAL_ROTATED);
	}

	public static boolean usesVerticalGlyphs (int orientation) {
		return ! usesHorizontalGlyphs (orientation);
	}
}
