/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2008 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.ut;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.ElementType;

/**
 * This attribute can be attached to classes or members of classes
 * to indicate that a particular FindBugs bug code should be suppressed
 * for that class or class member.
 * 
 * This attribute doesn't suppress the bug directly, but relies on a
 * tool extracting this information from the compiled jar file and using
 * it to construct an exclude filter file.
 * 
 * @author Andy Neilson
 * @exclude from published api.
 */

// Retention is SOURCE so that this attribute is never retained in the compiled
// class files, but is only processed transiently by the apt tool.
@Retention(RetentionPolicy.SOURCE)

// We don't support annotating ANNOTATION_TYPE or PARAMETER since FindBugs
// filters have no way to filter bugs at that level.
// TODO: We could apply this annotation to local variables (since FindBugs
//       supports it), but ExcludeFilterApf doesn't know how to accept local
//       variable declarations.
@Target({ElementType.CONSTRUCTOR, 
		 ElementType.FIELD, 
//		 ElementType.LOCAL_VARIABLE, 
		 ElementType.METHOD, 
		 ElementType.PACKAGE, 
		 ElementType.TYPE})
		 
public @interface FindBugsSuppress {
	public String code() default "";
	public String pattern() default "";
}