/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.ut;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;

/**
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */
public class ResourceLoader {

	private static final String gXFAResources = "com.adobe.xfa.messages_";

	private static final Properties mMessageStrings;

	private static final Properties mXFAProperties;

	static {
		// Search for and load language-specific resource file.
		String lang = Locale.getDefault().toString();
		if (StringUtils.isEmpty(lang))
			lang = "en";
		
		// Search for and load the locale's resource file.
		String resFile = gXFAResources + lang + ".properties";
		
		Properties messageStrings = load(resFile);
		
		// Failing that, search for and load the locale's language resource file.
		String deflt = Locale.getDefault().getLanguage();
		if (messageStrings == null && ! deflt.equals(lang)) {
			lang = deflt;
			resFile = gXFAResources + lang + ".properties";
			messageStrings = load(resFile);
		}

		// Failing that, search for and load En resource file.
		if (messageStrings == null && ! lang.equals("en"))
			messageStrings = load(gXFAResources + "en" + ".properties");
		
		mMessageStrings = messageStrings;

		// Search for and load properties file.
		String propFile = "com.adobe.xfa.environment.properties"; 
		mXFAProperties = load(propFile);
	}

	private static Properties load(String sFile) {
		
		InputStream is = ResourceLoader.class.getResourceAsStream("/" + sFile);
		
		if (is != null) {
			try {
				Properties properties = new Properties();
				properties.load(is);
				return properties;
			}
			catch (IOException ex) {				
			}
			finally {
				try { is.close(); }
				catch (IOException ignored) { }
			}
		}
		
		return null;
	}
	
	public static String loadResource(int nResId) {
		if (mMessageStrings != null) { 
		    String sResource = mMessageStrings.getProperty("IDS_XTG_" + Integer.toString(nResId));
		    if (sResource == null)
		    	sResource = "%s";
		    return sResource; 
		}
		return "Can't locate resource IDS_XTG_" + Integer.toString(nResId);
	}

	public static String loadProperty(String property) {
		String propertyValue = null;
		if (mXFAProperties != null)
			propertyValue = mXFAProperties.getProperty(property); 
		//
		// If property is unspecified then check system properties.
		//
		if (propertyValue == null)
			propertyValue = System.getProperty(property); 
		//
		// If property is still unspecified then 
		// supply some property-specific XFA defaults.
		// Avoid returning null!
		//
		if (propertyValue == null)
			propertyValue = "";
		return propertyValue;
	}
}