/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2011 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

package com.day.cq.replication;

/**
 * <code>AgentFilter</code> provides a simple interface to filter for agents.
 */
public interface AgentFilter {

    /**
     * Default filter that includes all non-specific agents.
     */
    AgentFilter DEFAULT = new AgentFilter() {
        public boolean isIncluded(Agent agent) {
            return !agent.getConfiguration().isSpecific();
        }
    };

    /**
     * Default filter that includes all agents that 'are triggered on distribute', i.e. are outbox agents.
     */
    AgentFilter OUTBOX_AGENT_FILTER = new AgentFilter(){
        public boolean isIncluded(Agent agent) {
            return agent.getConfiguration().isTriggeredOnDistribute();
        }
    };

    /**
     * Checks if the given agent is included by this filter.
     * @param agent the agent to check.
     * @return <code>true</code> if the given agent is included.
     */
    boolean isIncluded(Agent agent);
}