/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.api.reference;

import org.apache.sling.api.resource.Resource;

/**
 * The ReferencedResource represents a resource which is referenced from another {@link Resource}.
 * 
 * <p>
 * Unless otherwise noted, all fields contained in this class are not null.
 * </p>
 */
public class Reference {

    private final String type;
    private final String name;
    private final Resource resource;
    private final long lastModified;

    public Reference(String type, String name, Resource resource, long lastModified) {

        this.type = type;
        this.name = name;
        this.resource = resource;
        this.lastModified = lastModified;
    }

    /**
     * 
     * @return the type of the resource, for informative purposes
     */
    public String getType() {
        return type;
    }

    /**
     * 
     * @return the friendly name of the resource, for informative purposes
     */
    public String getName() {
        return name;
    }

    /**
     * 
     * @return the referenced resource
     */
    public Resource getResource() {
        return resource;
    }

    /**
     * 
     * @return the time when this resource was last modified, or -1 if the last modified time is not known
     */
    public long getLastModified() {
        return lastModified;
    }
}
