/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package ch.randelshofer.media.jpeg;

import javax.imageio.plugins.jpeg.JPEGImageReadParam;

/**
 * This class adds ability to set CMYK Jpeg image read parameters like
 * inverseYCCK color hint.
 */
public class CMYKJPEGImageReadParam extends JPEGImageReadParam {
    /**
     * Use adobe style inverse YCCK color calculation. Default value is true.
     */
    private boolean useInvertedYCCKColor = true;

    /**
     * Sets useInvertedColor flag. If this flag is set to true, reader can
     * assume that JPEG has inverse YCCK color and apply appropriate
     * transformation. Default value of this flag is <code>true</code>
     * 
     * @param inverted
     */
    public void setUseInvertedYCCKColor(boolean inverted) {
        useInvertedYCCKColor = inverted;
    }

    /**
     * Returns the current value of useInvertedColor flag.
     * 
     * @return true if useInvertedYCCKColor flag is set.
     */
    public boolean getUseInvertedYCCKColor() {
        return useInvertedYCCKColor;
    }
}
