/*
 * File: GlyphBBoxCalculator.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is
 *      obtained from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.FontData;

public interface GlyphBBoxCalculator {

    /**
     * Returns the bounding box of glyphID scaled to [1000 0 0 1000]
     * @param font
     * @param glyphID
     * @return the glyph bounding box.
     * @throws InvalidFontException
     * @throws UnsupportedFontException
     */
    public Rect calculateBBox(FontData font, int glyphID) 
    	throws InvalidFontException, UnsupportedFontException;
}
