package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.UnsupportedFontException;

class NoVORGVertOrigFetcher implements VerticalOriginFetcher {
	private final OpenTypeFont theFont;
	
	NoVORGVertOrigFetcher(OpenTypeFont theFont)
	{
		this.theFont = theFont;
	}
	
	public int getVOrigin(int gid) throws InvalidFontException, UnsupportedFontException {
		int topSideBearing = theFont.vmtx.getTopSideBearing(gid);
		Rect bbox = theFont.getGlyphBBox(gid);
		return (int)bbox.ymax + topSideBearing;
	}

}
