/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2021 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.granite.auth.saml.spi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("unchecked")
public final class Attribute {

    private String name;
    private String nameFormat;
    private Object attributeValue;

    public @Nullable String getName() {
        return name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public @Nullable String getNameFormat() {
        return nameFormat;
    }

    public void setNameFormat(@Nullable String nameFormat) {
        this.nameFormat = nameFormat;
    }

    public void addAttributeValue(@NotNull Object value) {
        if (null == this.attributeValue) {
            this.attributeValue = value;
        } else if (this.attributeValue instanceof List) {
            ((List) this.attributeValue).add(value);
        } else {
            Object oldValue = this.attributeValue;
            List<Object> newValue = new ArrayList<>();
            newValue.add(oldValue);
            newValue.add(value);
            this.attributeValue = newValue;
        }
    }

    public @Nullable Object getValue() {
        return this.attributeValue;
    }

    public @NotNull List<Object> getListValue() {
        List<Object> result;
        if (this.attributeValue instanceof List) {
            result = (List) this.attributeValue;
        } else {
            result = new ArrayList<>();
            result.add(this.attributeValue);
        }
        return result;
    }

}
