/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.omnisearch.api.suggestion;

import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;

/**TODO Need to confirm from UI what else information they require to show a predicate as Suggestion
 * <code>PredicateSuggestion</code> class have all the properties of
 * a predicate that is require to show predicate as a suggestion on UI.
 *
 */
@ProviderType
public final class PredicateSuggestion {

    /**
     * This is type of predicate. This is usually read from "text" property of
     * predicate
     */
    private String type;


    /**
     * Path of the node from where type property has been read i.e. path of the predicate node
     */
    private String typePath;

    /**
     * This is title of predicate value/option. This is usually read from "jcr:title" property of
     * option of predicate.
     */
    private String optionTitle;

    /**
     * path of the node from where option is read in jcr.
     */
    private String optionPath;

    /**
     * Map of query parameters of the predicate suggestion
     */
    private Map<String, String> queryParameters;

    /**
     * Creates a new instance of <code>PredicateSuggestion</code> i.e. File Type: Image
     * @param type Type of predicate i.e. "File Type"
     * @param optionTitle Title of predicate option i.e. "Image"
     */
    public PredicateSuggestion(String type, String optionTitle) {

        this(type, optionTitle, null, null);

    }


    /**
     * Creates a new instance of <code>PredicateSuggestion</code> i.e. File Type: Image
     * @param type Type of predicate i.e. "File Type"
     * @param optionTitle Title of predicate option i.e. "Image"
     * @param typePath Path of the type node in the JCR
     * @param optionPath Ppath of the node from where option is read in jcr.
     */
    public PredicateSuggestion(String type, String optionTitle, String typePath, String optionPath) {
        this.type = type;
        this.optionTitle = optionTitle;
        this.typePath = typePath;
        this.optionPath = optionPath;
        this.queryParameters = null;
    }

    /**
     * @return This is type of predicate. This is usually read from "text" property of
     * predicate. Please note that title is returned in default lang i.e. en. Should be converted
     * using i18n before rendering
     */
    public String getType() {
        return type;
    }

    /**
     *
     * @return Path of the node from where type property has been read i.e. path of the predicate node
     */

    public String getTypePath() {
        return typePath;
    }

    /**
     * @return title of predicate value/option. This is usually read from "jcr:title" property of
     * option of predicate. Please note that title is returned in default lang i.e. en. Should be converted
     * using i18n before rendering
     */
    public String getOptionTitle() {
        return optionTitle;
    }

    /**
     *
     * @return Path of the node from where option is read in jcr.
     */

    public String getOptionPath() {
        return  optionPath;
    }

    /**
     * @return Map of all the queryParameters that are associated with PredicateSuggestions
     */
    public Map<String, String> getQueryParameters() {
        return queryParameters;
    }

    /**
     *
     * @param queryParameters <code>Map</code> of Parameters that needed to be included in
     *                        <code>PredicateSuggestion</code>
     */
    public void setQueryParameters(Map<String, String> queryParameters) {
        this.queryParameters = queryParameters;
    }
}
