/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.omnisearch.api.suggestion;

import org.osgi.annotation.versioning.ProviderType;

import java.util.List;

/**
 * SuggestionResult encapsulate results of suggestion query, spellcheck and predicate suggestion
 */
@ProviderType
public final class SuggestionResult {

    private List<PredicateSuggestion> predicateSuggestions;

    private List<String> suggestions;

    private List<String> spellCheckSuggestions;

    /**
     * Creates new <code>SuggestionResult</code> instance
     * @param suggestions  List of suggestions
     * @param spellCheckSuggestions List of spellcheck suggestions
     * @param predicateSuggestions  List of <code>PredicateSuggestion</code>
     */
    public SuggestionResult(List<String> suggestions, List<String> spellCheckSuggestions, List<PredicateSuggestion> predicateSuggestions) {
        this.predicateSuggestions = predicateSuggestions;
        this.suggestions = suggestions;
        this.spellCheckSuggestions = spellCheckSuggestions;
    }

    /**
     * This function returns<code>List</code> of <code>PredicateSuggestions</code>
     * for the module.
     * @return list
     */
    public List<PredicateSuggestion> getPredicateSuggestions() {
        return predicateSuggestions;
    }

    /**
     * This function returns the list of suggestions for search term
     * for the module.
     * @return list
     */
    public List<String> getSuggestions() {
        return suggestions;
    }

    /**
     * this function returns the spell check suggestions for the search term
     * for the module.
     *
     * @return list
     */
    public List<String> getSpellcheckSuggestions() {
        return spellCheckSuggestions;
    }
}
