/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.status;

import com.adobe.granite.workflow.exec.Workflow;

import java.util.List;

/**
 * The <code>WorkflowStatus</code> holds all information for a node which
 * is in the workflow or even not
 */
public interface WorkflowStatus {
    /**
     * Indicates if a page is subject of a workflow
     *
     * @param excludeSystemWorkflows set to <code>true</code> to exclude system
     *        workflows from the evaluation
     *
     * @return <code>true</code> if subject of a workflow otherwise
     * <code>false</code>
     */
    boolean isInRunningWorkflow(boolean excludeSystemWorkflows);

    /**
     * Returns the <code>{@link com.adobe.granite.workflow.exec.Workflow} instances</code>
     *
     * @param excludeSystemWorkflows set to <code>true</code> to exclude system
     *        workflows from the evaluation
     *
     * @return <code>{@link com.adobe.granite.workflow.exec.Workflow} instances</code>
     */
    List<Workflow> getWorkflows(boolean excludeSystemWorkflows);
}
