/*
 *
 *	File: ByteSequence.java
 *
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.internal.util;

/**
 * @author sgill
 *
 */
public interface ByteSequence
{
    /**
     * Returns the byte at the specified index.  An index ranges from zero
     * to <tt>length() - 1</tt>.  The first byte of the sequence is at
     * index zero, the next at index one, and so on, as for array
     * indexing. </p>
     *
     * @param   index   the index of the character to be returned
     *
     * @return  the specified byte
     *
     * @throws  IndexOutOfBoundsException
     *          if the <tt>index</tt> argument is negative or not less than
     *          <tt>length()</tt>
     */
    byte byteAt(int index);
    
    /**
     * Returns the length of this byte sequence.  The length is the number
     * of bytes in the sequence. </p>
     *
     * @return  the number of bytes in this sequence
     */
    int length();
    
    /**
     * Returns a new byte sequence that is a subsequence of this sequence.
     * The subsequence starts with the byte at the specified index and
     * ends with the byte at index <tt>end - 1</tt>.  The length of the
     * returned sequence is <tt>end - start</tt>, so if <tt>start == end</tt>
     * then an empty sequence is returned. </p>
     * 
     * @param   start   the start index, inclusive
     * @param   end     the end index, exclusive
     *
     * @return  the specified subsequence
     *
     * @throws  IndexOutOfBoundsException
     *          if <tt>start</tt> or <tt>end</tt> are negative,
     *          if <tt>end</tt> is greater than <tt>length()</tt>,
     *          or if <tt>start</tt> is greater than <tt>end</tt>
     */
    ByteSequence subSequence(int start, int end);
    
    /**
     * Returns a byte array containing the bytes in this sequence in the same
     * order as this sequence.  The length of the byte array will be the length of
     * this sequence. </p>
     *
     * @return  a byte array consisting of exactly this sequence of bytes
     */
    byte[] getBytes();
    
    /**
     * Returns a byte array containing the bytes in this sequence in the same
     * order as this sequence and within the bounds given.  The length of the 
     * byte array will be equal to <tt>srcEnd - srcBegin + 1</tt>. </p>
     *
     * @param srcBegin the byte to start copying from
     * @param srcEnd the byte to end copying at
     * @param dst the destination to copy the bytes to
     * @param dstBegin the byte in the destination to begin the copying
     */
    void getBytes(int srcBegin, int srcEnd, byte dst[], int dstBegin);
}
