package com.adobe.xfa.text;

import java.util.List;

import com.adobe.xfa.text.markup.MarkupOut;

/**
 * @exclude from published api.
 */

class StrField extends StrItem {
	protected final TextField mpoField;
	protected int meLegacyLevel;

	StrField (TextField poNewField, TextGfxSource oGfxSource, int eLegacyLevel) {
		super (TextItem.FIELD);
		mpoField = poNewField.cloneField();
//		if (oGfxSource.Pool() != null) {
//			mpoField.AttrPool (oGfxSource.Pool());
//		}
//
//		if (oGfxSource.FontService() != null) {
//			mpoField.FontService (oGfxSource.FontService());
//		}

		cascadeLegacyLevel (eLegacyLevel);
	}

	void addField (List<TextField> oFields) {
		oFields.add (mpoField);
	}

	TextAttr markup (MarkupOut oMarkup, int nStart, int nSize, boolean bFlattenFields, TextAttr poPrevAttr) {
		if (! bFlattenFields) {
			oMarkup.field (mpoField);
		}
		else {
			mpoField.markup (oMarkup, null, true, false);
			poPrevAttr = null; // field may have changed attrs
		}
		return poPrevAttr;
	}

	TextField fieldAt (int nIndex) {
		return mpoField;
	}

	boolean isEqual (StrItem poCompare) {
		if (! (poCompare instanceof StrField)) {
			return false;
		}
		StrField poFieldItem = (StrField) poCompare;
		TextField poCompareField = poFieldItem.mpoField;

		if ((mpoField == null) || (poCompareField == null)) {
			return mpoField == poCompareField;
		}

//		if (mpoField.Type() != poCompareField.Type()) {
//			return false;
//		}

		return mpoField.isEqual (poCompareField);
	}

	StrItem cloneItem (TextGfxSource oGfxSource) {
		return new StrField (mpoField, oGfxSource, meLegacyLevel);
	}

	void gfxSource (TextGfxSource oGfxSource) {
		if (mpoField != null) {
			mpoField.gfxSource (oGfxSource);
		}
	}

	void cascadeLegacyLevel (int eLevel) {
		meLegacyLevel = eLevel;
		if (mpoField != null) {
			mpoField.setLegacyLevel (eLevel);
		}
	}

	void debug (int indent) {
		System.out.println (Pkg.doIndent (indent+1) + "Field");
		if (mpoField != null) {
			mpoField.debug (indent + 1);
		}
	}
}
