/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.commons;

import javax.jcr.RepositoryException;

import org.apache.sling.api.SlingException;

/**
 * The <code>SlingRepositoryException</code> is a runtime exception wrapper for
 * the <code>RepositoryException</code>. This exception is used to catch an
 * <code>RepositoryException</code> and forward it as a runtime exception to be
 * handled at the outermost level.
 */
public class SlingRepositoryException extends SlingException {

    private static final long serialVersionUID = -640951864189570350L;

    /**
     * Constructs a new sling repository exception
     * @param cause the repository exception
     */
    public SlingRepositoryException(RepositoryException cause) {
        super(cause);
    }

    /**
     * Constructs a new sling repository exception
     * @param text the message
     * @param cause the repository exception
     */
    public SlingRepositoryException(String text, RepositoryException cause) {
        super(text, cause);
    }
}