/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2011 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

package com.day.cq.replication;

/**
 * This exception is thrown by a transport handler when the underlying
 * transport (e.g. HTTP) received an unexpected answer from the remote
 * peer.
 */
public class TransportException extends ReplicationException {

    private static final long serialVersionUID = -2229496808305406859L;

    /**
     * Replication result.
     */
    private ReplicationResult result;

    /**
     * Create a new instance of this class.
     *
     * @param code
     *            error code
     * @param message
     *            error message
     */
    public TransportException(int code, String message) {
        super(message);

        result = new ReplicationResult(false, code, message);
    }

    /**
     * Return the replication result.
     *
     * @return replication result
     */
    public ReplicationResult getResult() {
        return result;
    }
}
