/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.core.references;

import org.apache.sling.api.resource.Resource;

import com.adobe.granite.references.Reference;

public class ContentReference extends Reference {

    private final ContentReferenceDescription contentReferenceDescription;

    public ContentReference(Resource source, Resource target,
            ContentReferenceDescription contentReferenceDescription, String type) {
        super(source, target, type);
        this.contentReferenceDescription = contentReferenceDescription;
    }

    /**
     * Returns the {@link ContentReferenceDescription} which describes the reference's
     * source resource.
     * 
     * @return The content reference description
     */
    public ContentReferenceDescription getContentReferenceDescription() {
        return contentReferenceDescription;
    }

}
