/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.targetrecommendations.api.model;

import org.osgi.annotation.versioning.ProviderType;

/**
 * Abstraction of a Target Recommendation Algorithm
 */
@ProviderType
public interface RecommendationAlgorithm extends RecommendationsEntity {
    
    /**
     * Uniquely identifies a recommendation algorithm
     * 
     * @return value identifying this {@code RecommendationAlgorithm}
     */
    public int getId();

    /**
     * Get the name of this {@code RecommendationAlgorithm}
     * 
     * @return a {@link String} object containing this algorithm's name
     */
    public String getName();
    
    /**
     * Get the configuration of this {@code RecommendationAlgorithm}
     * 
     * @return a {@link RecommendationAlgorithmConfiguration} object containing this recommendation's configuration parameters
     */
    public RecommendationAlgorithmConfiguration getConfiguration();
}
