/*
*
*	File: VmtxRaw.java
*
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2004-2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
*/

package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;

/** Gives access to a raw 'vmtx' table.
 * 
 * <p>'vtmx' tables do not stand one their own; see 
 * {@link com.adobe.fontengine.font.opentype.Vmtx} for a 
 * wrapping which corrects that.</p>
 * 
 * <h4>Version handling</h4>
 * 
 * <p>'vmtx' tables are not versionned.</p>
 *
 * <h4>Synchronization</h4>
 * 
 * <p>Like all tables, these objects are immutable.</p> 
 **/

final class VmtxRaw extends Table {

  protected VmtxRaw (FontByteArray buffer) 
      throws java.io.IOException, InvalidFontException, UnsupportedFontException {
    super (buffer);
  }
  
  /** Get the top side bearing of the glyph <code>glyphID</code>. */
  public int getTopSideBearing (int glyphID, int numberOfVMetrics)
      throws InvalidFontException {
    if (glyphID < numberOfVMetrics) {
      return this.data.getint16 (4*glyphID + 2); }
    else {
      return this.data.getint16 (4*numberOfVMetrics + 2*(glyphID - numberOfVMetrics)); }
  } 

  /** Get the vertical advance of the glyph <code>glyphID</code>. */
  public int getVerticalAdvance (int glyphID, int numberOfVMetrics)
      throws InvalidFontException {
    if (glyphID < numberOfVMetrics) {
      return this.data.getuint16 (4*glyphID); }
    else {
      return this.data.getuint16 (4*(numberOfVMetrics - 1)); }
  }
}

