/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.haf.converter.api;

import org.osgi.annotation.versioning.ProviderType;

/**
 * An interface that models a content type used by the framework to do the content negotation in order to choose
 * the HypermediaConverter to be used to serialize the model.
 */
@ProviderType
public interface ContentType extends Comparable<ContentType> {
    /**
     * Determines whether the ContentType is a match for the provided content type string.
     * @param type The content type string that is matched against this instance.
     * @return Whether or not the current instance matches with the content type string.
     */
    boolean matches(String type);

    /**
     * Gets the quality specified for the content type.  For example for the content type application/json;q=0.8 the
     * quality would be 0.8.
     * @return The quality.
     */
    float getQuality();

    /**
     * Get the primary segment of the content type.  For example, for the content type application/json;q=0.8 the
     * primary segment would be application.
     * @return The primary segment.
     */
    String getPrimary();

    /**
     * Get the secondary segment of the content type.  For example, for the content type application/json;q=0.8 the
     * secondary segment would be json.
     * @return The secondary segment.
     */
    String getSecondary();

    /**
     * Get the type defined in the content type instance.  For example, for the content type application/json;q=0.8 the
     * type would be application/json.
     * @return The type.
     */
    String getType();

    /**
     * Determines whether the ContentType represents a wildcard.  A wildcard content type has a type of {@code *\/*}.
     * @return Whether the ContentType is a wildcard.
     */
    boolean isWildCard();

    /**
     * Returns the token score for the ContentType.  The token score is a measure of how detailed the content type is.
     * A content that provides a primary and secondary segment (not a wildcard), as well as a quality and any other
     * parameters will have a higher token score than a ContentType that does not.  The framework prioritizes matches
     * on a ContentType with higher token scores than those with lower token scores.
     * @return Token score
     */
    int getTokenScore();
}
